<?php
class UsersAdmin
{
  private $dbo = null;
  function __construct($dbo)
  {
    $this->dbo = $dbo;
  }
  function getQuerySingleResult($query)
  {
    //Brak obiektu $dbo
    if(!$this->dbo) return false;
    
    //Wykonanie zapytania.
    if(!$result = $this->dbo->query($query)){
      //echo 'Wystpi bd (getQuerySingleResult): nieprawidowe zapytanie...';
      return false;
    }
    if($row = $result->fetch_row()){
      //Zwrcenie wyniku.
      return $row[0];
    }
    else{
      //Brak wynikw zapytania.
      return false;
    }
  }
  function getPagination($page, $pages, $link, $msg)
  {
    $str = '';
    for($i = 0; $i < $pages; $i++){
      if($i != $page){
        $str .= "<a href=\"$link&amp;page=$i\">".($i+1)."</a>";
      }
      else{
        $str .= '<span class="activePaginationPage">' . ($i+1)
              . '</span>';
      }
      $str .= '<span class="space"> </span>';
    }
    $str = $msg . $str;
    return $str;
  }
  function showList($limit)
  {
    if(!$this->dbo){
      echo 'Lista uytkownikw nie jest dostpna.';
      return;
    }
    
    //Odczytanie parametru page
    if(isset($_GET['page'])){
      $page = intval($_GET['page']);
    }
    else{
      $page = 0;
    }
    
    //Okrelenie cakowitej liczby wierszy w tabeli Users
    $query = "SELECT COUNT(*) FROM Users";
    $rowsCount = (int) $this->getQuerySingleResult($query);
    
    //Obliczenie cakowitej liczby stron z wynikami
    $pages = ceil($rowsCount / $limit);
    
    if($page < 0 || $page >= $pages) $page = 0;
    
    $offset = $page * $limit;
    
    //Zapytanie pobierajce wyniki dla biecej strony
    $query = "SELECT Id, Nazwa, Imie, Nazwisko, Email "
           . "FROM Users LIMIT $offset, $limit";

    if(!$users = $this->dbo->query($query)){
      return;
    }
    include 'templates/usersList.php';
  }
}
?>